<?php

namespace App\Http\Controllers;

use App\Models\CentrosUtilidad;
use App\Models\AvanceModulos;
use Illuminate\Http\Request;

class CentrosUtilidadController extends Controller
{
    private $apiKey;

    function __construct() {
        $apiController = new ApiController();

        $this->apiKey = $apiController->getApiKey()["key"];
    }

    public function crearCentroUtilidad(Request $request) {
        $id = new \stdClass();

        \DB::transaction(function() use(&$id, $request) {
            $centroUtilidad = CentrosUtilidad::on('costos_principal');

            $id = $centroUtilidad->create(
                [
                    "con_fk_id" => $request->input("con_fk_id"),
                    "ins_fk_id" => $request->input("ins_fk_id"),
                    "cut_ano" => $request->input("cut_ano"),
                    "cut_codigo" => $request->input("cut_codigo"),
                    "cut_descripcion" => $request->input("cut_descripcion")
                ]
            );

            $this->verificarAvance($request->input("con_fk_id"),
                                   $request->input("ins_fk_id"),
                                   $request->input("cut_ano"));
        });

        return array("response" => $id->cut_pk_id);
    }

    public function actualizarCentroUtilidad(Request $request) {
        CentrosUtilidad::on('costos_principal')
                       ->where("con_fk_id", $request->input("con_fk_id"))
                       ->where("ins_fk_id", $request->input("ins_fk_id"))
                       ->where("cut_ano", $request->input("cut_ano"))
                       ->where("cut_codigo", $request->input("cut_codigo"))
        ->update(
            [
                "cut_descripcion" => $request->input("cut_descripcion")
            ]
        );
    }

    public function borrarCentroUtilidad(Request $request) {
        \DB::transaction(function() use($request) {
            CentrosUtilidad::on('costos_principal')
                           ->where("cut_pk_id", $request->input("cut_pk_id"))
                           ->delete();

            $this->verificarAvance($request->input("con_fk_id"),
                                   $request->input("ins_fk_id"),
                                   $request->input("cut_ano"));
        });
    }

    public function getCentrosUtilidad(Request $request) {
        return CentrosUtilidad::on('costos_principal')
                              ->where('con_fk_id', $request->input('con_fk_id'))
                              ->where('ins_fk_id', $request->input('ins_fk_id'))
                              ->where('cut_ano', $request->input('cut_ano'))
                              ->orderBy('cut_codigo')
                              ->orderBy('cut_descripcion')
                              ->get()->toArray();

    }

    public function cargarArchivoCentrosUtilidad(Request $request) {
        $apiKey = $request->apiKey;

        if ($apiKey === $this->apiKey) {
            $rutaDelArchivo = $request->centrosUtilidad->path();
            $delimitador = $request->delimitador;
            $archivo = fopen($rutaDelArchivo, 'r');
            $centrosUtilidad = array();
            $primeraLinea = true;

            // Extraer cada línea del archivo CSV y convertirlo en un arreglo
            while($linea = fgetcsv($archivo, 1000, $delimitador)) {
                if (!$primeraLinea) {
                    $registro = $linea;
                    array_push($centrosUtilidad, $registro);
                } else {
                    $primeraLinea = false;
                }
            }

            fclose($archivo);

            return $this->procesarArchivoCentrosUtilidad($centrosUtilidad,
                                                         $request->con_fk_id,
                                                         $request->ins_fk_id,
                                                         $request->cut_ano);
        } else {
            throw new \Exception('Imposible completar la petición.');
        }
    }

    private function procesarArchivoCentrosUtilidad($centrosUtilidad, $con_fk_id, $ins_fk_id, $cut_ano) {
        $resultados = new \stdClass();
        $resultados->errores = "";

        \DB::transaction(function() use(&$resultados, $centrosUtilidad, $con_fk_id, $ins_fk_id, $cut_ano) {
            if (count($centrosUtilidad) === 0) {
                $resultados->correcto = false;
                $resultados->errores = 'El archivo está vacío. ';
                return json_encode($resultados);
            } else if (count($centrosUtilidad[0]) !== 2) {
                $resultados->correcto = false;
                $resultados->errores = 'La cantidad de columnas no corresponde. ';
                return json_encode($resultados);
            } else {
                $centrosUtilidadBd = CentrosUtilidad::on('costos_principal')
                                                    ->where('con_fk_id', $con_fk_id)
                                                    ->where('ins_fk_id', $ins_fk_id)
                                                    ->where('cut_ano', $cut_ano)
                                                    ->get()->toArray();

                $centrosUtilidadExistentes = [];
                $registrosProcesados = 0;

                // Crear las relaciones existentes en la base de datos
                foreach ($centrosUtilidadBd as $cutDb) {
                    $centrosUtilidadExistentes[$cutDb['cut_codigo']] = $cutDb['cut_descripcion'];
                }

                // Errores de los centros de utilidad
                $codCentroErroneo = "";
                $descripcionLargas = false;

                // Revisar el archivo respecto a las relaciones existentes
                foreach($centrosUtilidad as $cutCsv) {
                    $centUt = strtoupper(utf8_encode(trim($cutCsv[0])));
                    $descripcion = utf8_encode($cutCsv[1]);

                    // Existe el centro de utilidad
                    if (isset($centrosUtilidadExistentes[$centUt])) {
                        // Actualizar si el nombre el diferente
                        if ($centrosUtilidadExistentes[$centUt] != $descripcion) {
                            // Descripcion largas
                            if (strlen($descripcion) <= 80) {
                                CentrosUtilidad::on('costos_principal')
                                            ->where("con_fk_id", $con_fk_id)
                                            ->where("ins_fk_id", $ins_fk_id)
                                            ->where("cut_ano", $cut_ano)
                                            ->where("cut_codigo", $centUt)
                                ->update(
                                    [
                                        "cut_descripcion" => $descripcion
                                    ]
                                );

                                $registrosProcesados++;
                            } else {
                                $descripcionLargas = true;
                            }
                        } else {
                            $registrosProcesados++;
                        }
                    } else { // No existe, es necesario crearlo
                        if (strlen($centUt) == 1 && (ctype_alpha($centUt) || is_numeric($centUt))) {
                            if (strlen($descripcion) <= 80) {
                                $centroUtilidad = CentrosUtilidad::on('costos_principal');

                                $id = $centroUtilidad->create(
                                    [
                                        "con_fk_id" => $con_fk_id,
                                        "ins_fk_id" => $ins_fk_id,
                                        "cut_ano" => $cut_ano,
                                        "cut_codigo" => $centUt,
                                        "cut_descripcion" => $descripcion
                                    ]
                                );

                                $registrosProcesados++;

                                $centrosUtilidadExistentes[$centUt] = $descripcion;
                            } else {
                                $descripcionLargas = true;
                            }
                        } else {
                            $codCentroErroneo .= $centUt.", ";
                        }
                    }
                }

                // Errores de subcentros de utilidad
                if ($codCentroErroneo !== "") {
                    $codCentroErroneo[strlen($codCentroErroneo) - 1] = " ";
                    $codCentroErroneo[strlen($codCentroErroneo) - 2] = " ";
                    $codCentroErroneo = "Los siguientes códigos tienen más de un caracter: ".$codCentroErroneo;

                    $resultados->errores = $codCentroErroneo;
                }

                // Descripciones largas
                if ($descripcionLargas) {
                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores .= "Hay descripciones de más de 80 caracteres";
                }

                if (!$descripcionLargas && $codCentroErroneo === "") {
                    $resultados->correcto = true;
                } else {
                    $resultados->correcto = false;
                }

                $resultados->registros = $registrosProcesados;
            }

            $this->verificarAvance($con_fk_id, $ins_fk_id, $cut_ano);
        });

        return json_encode($resultados);
    }

    public function verificarAvance($contrato, $institucion, $ano) {
        // Verificar si existe registro del avance
        $conteo = AvanceModulos::on('costos_principal')
                               ->where('con_fk_id', $contrato)
                               ->where('ins_fk_id', $institucion)
                               ->where('avm_ano', $ano)
                               ->whereNull('avm_mes')
                               ->count();

        // Verificar el avance del modulo
        $cut = CentrosUtilidad::on('costos_principal')
                              ->where('con_fk_id', $contrato)
                              ->where('ins_fk_id', $institucion)
                              ->where('cut_ano', $ano)
                              ->count();

        if ($conteo > 0) {
            if ($cut > 0) {
                AvanceModulos::on('costos_principal')
                                ->where('con_fk_id', $contrato)
                                ->where('ins_fk_id', $institucion)
                                ->where('avm_ano', $ano)
                                ->where('avm_mes', null)
                ->update(
                    [
                        "avm_cut" => true
                    ]
                );
            } else {
               AvanceModulos::on('costos_principal')
                            ->where('con_fk_id', $contrato)
                            ->where('ins_fk_id', $institucion)
                            ->where('avm_ano', $ano)
                            ->where('avm_mes', null)
                ->update(
                    [
                        "avm_cut" => false,
                        "avm_scu" => false,
                        "avm_cco" => false
                    ]
                ); 
            }
        } else {
            AvanceModulos::on('costos_principal')
            ->create(
                [
                    "con_fk_id" => $contrato,
                    "ins_fk_id" => $institucion,
                    "avm_ano" => $ano,
                    "avm_mes" => null,
                    "avm_cut" => true
                ]
            );
        }            
    }
}
