<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class InstitucionesReps extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('instituciones_reps', function (Blueprint $table) {
            $table->string('inr_pk_id', 50);
            $table->string('inr_nit', 50);
            $table->string('inr_razon_social', 300);
            $table->string('inr_rep_legal', 200)->nullable();
            $table->integer('dep_fk_id');
            $table->integer('mun_fk_id');
            $table->string('inr_direccion', 400)->nullable();

            // Llaves foraneas
            $table->primary('inr_pk_id');
            $table->foreign('dep_fk_id')->references('dep_pk_id')->on('departamentos')->onDelete('cascade');
            $table->foreign('mun_fk_id')->references('mun_pk_id')->on('municipios')->onDelete('cascade');

            $table->index('inr_pk_id');
            $table->index('dep_fk_id');
            $table->index('mun_fk_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('instituciones_reps');
    }
}
