<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class RelCucGrSuministros extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('rel_cuc_gr_suministros', function (Blueprint $table) {
            $table->increments('rgc_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('rgc_ano');
            $table->integer('grs_fk_id');
            $table->integer('cco_fk_id');
            $table->integer('cuc_fk_id');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');

            $table->index(['con_fk_id', 'ins_fk_id', 'rgc_ano', 'grs_fk_id']);

            $table->unique(['con_fk_id', 'ins_fk_id', 'rgc_ano', 'grs_fk_id', 'cco_fk_id', 'cuc_fk_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('rel_cuc_gr_suministros');
    }
}
