<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class SuministrosDirectos extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('suministros_directos', function (Blueprint $table) {
            $table->increments('sud_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('sud_ano');
            $table->integer('sud_mes');
            $table->integer('cco_fk_id');
            $table->integer('act_fk_id');
            $table->integer('sum_fk_id');
            $table->float('sud_costo')->nullable();

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');
            $table->foreign('act_fk_id')->references('act_pk_id')->on('actividades')->onDelete('cascade');
            $table->foreign('sum_fk_id')->references('sum_pk_id')->on('suministros')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'sud_ano', 'sud_mes', 'cco_fk_id', 'act_fk_id', 'sum_fk_id']);

            $table->index(['con_fk_id', 'ins_fk_id', 'sud_ano', 'sud_mes'], 'sud_index1');
            $table->index(['sud_ano', 'sud_mes', 'con_fk_id', 'ins_fk_id', 'cco_fk_id'], 'sud_index2');
            $table->index(['sud_ano', 'sud_mes', 'con_fk_id', 'ins_fk_id', 'cco_fk_id', 'act_fk_id'], 'sud_index3');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('suministros_directos');
    }
}
