<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CostoPaquetes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('costo_paquetes', function (Blueprint $table) {
            $table->bigIncrements('cpq_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('cpq_ano');
            $table->integer('cpq_mes');
            $table->integer('cpq_paquete');
            $table->integer('cco_fk_id');
            $table->integer('act_fk_id')->nullable();
            $table->integer('sum_fk_id')->nullable();

            $table->float('cpq_mob_dir_costo');
            $table->float('cpq_mob_indir_costo');
            $table->float('cpq_sum_dir_costo');
            $table->float('cpq_sum_indir_costo');
            $table->float('cpq_gastos_gen_costo');
            $table->float('cpq_costo_dist_costo');

            $table->float('cpq_costo');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cpq_paquete')->references('act_pk_id')->on('actividades')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');
            $table->foreign('act_fk_id')->references('act_pk_id')->on('actividades')->onDelete('cascade');
            $table->foreign('sum_fk_id')->references('sum_pk_id')->on('suministros')->onDelete('cascade');

            $table->index(['con_fk_id', 'ins_fk_id', 'cpq_ano', 'cpq_mes'], 'cpq_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'cpq_ano', 'cpq_mes', 'cpq_paquete'], 'cpq_index2');
            $table->index(['con_fk_id', 'ins_fk_id', 'cpq_ano', 'cpq_mes', 'cpq_paquete', 'cco_fk_id'], 'cpq_index3');
            $table->index(['con_fk_id', 'ins_fk_id', 'cpq_ano', 'cpq_mes', 'cpq_paquete', 'cco_fk_id', 'act_fk_id'], 'cpq_index4');
            $table->index(['con_fk_id', 'ins_fk_id', 'cpq_ano', 'cpq_mes', 'cpq_paquete', 'cco_fk_id', 'sum_fk_id'], 'cpq_index5');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('costo_paquetes');
    }
}
