<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CostosIngresos extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('costos_ingresos', function (Blueprint $table) {
            $table->increments('coi_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('coi_ano');
            $table->integer('coi_mes');
            $table->integer('cco_fk_id');
            $table->float('coi_costo');
            $table->float('coi_ingresos');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'coi_ano', 'coi_mes', 'cco_fk_id']);

            $table->index(['con_fk_id', 'ins_fk_id', 'coi_ano', 'coi_mes'], 'coi_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'coi_ano', 'coi_mes', 'cco_fk_id'], 'coi_index2');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('costos_ingresos');
    }
}
