<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class DistribucionValorDirecto extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('distribucion_valor_directo', function (Blueprint $table) {
            $table->increments('dvd_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('dvd_ano');
            $table->integer('dvd_mes');
            $table->integer('ifm_fk_id');
            $table->integer('cco_fk_id');
            $table->float('dvd_valor');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('ifm_fk_id')->references('ifm_pk_id')->on('informacion_financiera')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'dvd_ano', 'dvd_mes', 'ifm_fk_id', 'cco_fk_id']);

            $table->index(['con_fk_id', 'ins_fk_id', 'dvd_ano', 'dvd_mes'], 'dvd_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'dvd_ano', 'dvd_mes', 'ifm_fk_id'], 'dvd_index2');
            $table->index(['con_fk_id', 'ins_fk_id', 'dvd_ano', 'dvd_mes', 'ifm_fk_id', 'cco_fk_id'], 'dvd_index3');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('distribucion_valor_directo');
    }
}
