<?php

namespace App\Http\Controllers;

use App\Models\BasesDistribucion;
use App\Models\AvanceModulos;
use Illuminate\Http\Request;

class BasesDistribucionController extends Controller
{
    private $apiKey;

    function __construct() {
        $apiController = new ApiController();

        $this->apiKey = $apiController->getApiKey()["key"];
    }

    public function crearBaseDistribucion(Request $request) {
        $id = new \stdClass();

        \DB::transaction(function() use(&$id, $request) {
            $baseDistribucion = BasesDistribucion::on('costos_principal');

            $id = $baseDistribucion->create(
                [
                    "con_fk_id" => $request->input("con_fk_id"),
                    "ins_fk_id" => $request->input("ins_fk_id"),
                    "bdi_ano" => $request->input("bdi_ano"),
                    "bdi_codigo" => $request->input("bdi_codigo"),
                    "bdi_descripcion" => $request->input("bdi_descripcion"),
                    "bdi_predefinida" => false
                ]
            );
            
            $this->verificarAvance($request->input("con_fk_id"),
                                   $request->input("ins_fk_id"),
                                   $request->input("bdi_ano"));
        });

        return array("response" => $id->bdi_pk_id);
    }

    public function actualizarBaseDistribucion(Request $request) {
        BasesDistribucion::on('costos_principal')
                         ->where("bdi_pk_id", $request->input("bdi_pk_id"))
                         ->where("con_fk_id", $request->input("con_fk_id"))
                         ->where("ins_fk_id", $request->input("ins_fk_id"))
                         ->where("bdi_ano", $request->input("bdi_ano"))
        ->update(
            [
                "bdi_codigo" => $request->input("bdi_codigo"),
                "bdi_descripcion" => $request->input("bdi_descripcion")
            ]
        );
    }

    public function borrarBaseDistribucion(Request $request) {
        \DB::transaction(function() use($request) {
            BasesDistribucion::on('costos_principal')
                            ->where("bdi_pk_id", $request->input("bdi_pk_id"))
                            ->delete();
                            
            $this->verificarAvance($request->input("con_fk_id"),
                                   $request->input("ins_fk_id"),
                                   $request->input("bdi_ano"));
        });
    }

    public function verificarCodigoBase(Request $request) {
        $codigo = $request->input('bdi_codigo');

        if (trim($codigo) == '1' || trim($codigo) == '2' || trim($codigo) == '3' || trim($codigo) == '4' || trim($codigo) == '5' ||
            trim($codigo) == '6' || trim($codigo) == '7' || trim($codigo) == '8') {
            return 1;
        }

        return BasesDistribucion::on('costos_principal')
                                ->where('con_fk_id', $request->input('con_fk_id'))
                                ->where('ins_fk_id', $request->input('ins_fk_id'))
                                ->where('bdi_ano', $request->input('bdi_ano'))
                                ->where('bdi_codigo', $codigo)
                                ->count();
    }

    public function getBasesDistribucion(Request $request) {
        return \DB::select("select *
                            from costos_principal.bases_distribucion
                            where (con_fk_id = ".$request->input('con_fk_id')." or con_fk_id is null) and
                                  (ins_fk_id = '".$request->input('ins_fk_id')."' or ins_fk_id is null) and
                                  (bdi_ano = ".$request->input('bdi_ano')." or bdi_ano is null) and
                                  bdi_pk_id != 1 and
                                  bdi_mano_obra = false
                            order by bdi_pk_id, bdi_descripcion asc");

    }

    public function getBasesDistribucionDistCostos(Request $request) {
        return \DB::select("select *
                            from costos_principal.bases_distribucion
                            where (con_fk_id = ".$request->input('con_fk_id')." or con_fk_id is null) and
                                  (ins_fk_id = '".$request->input('ins_fk_id')."' or ins_fk_id is null) and
                                  (bdi_ano = ".$request->input('bdi_ano')." or bdi_ano is null) and
                                  bdi_pk_id != 1 and
                                  bdi_mano_obra = false
                            order by bdi_pk_id, bdi_descripcion asc");

    }

    public function getBasesDistribucionSinCostoPrimario(Request $request) {
        return \DB::select("select *
                            from costos_principal.bases_distribucion
                            where (con_fk_id = ".$request->input('con_fk_id')." or con_fk_id is null) and
                                  (ins_fk_id = '".$request->input('ins_fk_id')."' or ins_fk_id is null) and
                                  (bdi_ano = ".$request->input('bdi_ano')." or bdi_ano is null) and
                                  bdi_pk_id != 4 and
                                  bdi_pk_id != 5 and
                                  bdi_pk_id != 6 and
                                  bdi_pk_id != 7 and
                                  bdi_pk_id != 8 and
                                  bdi_mano_obra = false
                            order by bdi_pk_id, bdi_descripcion asc");

    }

    public function getBasesDistribucionUsuario(Request $request) {
        return BasesDistribucion::on('costos_principal')
                                ->where('bdi_mano_obra', false)
                                ->where('con_fk_id', $request->input('con_fk_id'))
                                ->where('ins_fk_id', $request->input('ins_fk_id'))
                                ->where('bdi_ano', $request->input('bdi_ano'))
                                ->where('bdi_predefinida', false)
                                ->orderBy('bdi_descripcion')
                                ->get()->toArray();

    }

    public function getBasesDistribucionCompletas(Request $request) {
        return \DB::select("select *
                            from costos_principal.bases_distribucion
                            where (con_fk_id = ".$request->input('con_fk_id')." or con_fk_id is null) and
                                  (ins_fk_id = '".$request->input('ins_fk_id')."' or ins_fk_id is null) and
                                  (bdi_ano = ".$request->input('bdi_ano')." or bdi_ano is null) and
                                  bdi_mano_obra = false
                            order by bdi_pk_id, bdi_descripcion asc");

    }

    public function cargarArchivoBasesDistribucion(Request $request) {
        $apiKey = $request->apiKey;

        if ($apiKey === $this->apiKey) {
            $rutaDelArchivo = $request->basesDistribucion->path();
            $delimitador = $request->delimitador;
            $archivo = fopen($rutaDelArchivo, 'r');
            $basesDistribucion = array();
            $primeraLinea = true;

            // Extraer cada línea del archivo CSV y convertirlo en un arreglo
            while($linea = fgetcsv($archivo, 1000, $delimitador)) {
                if (!$primeraLinea) {
                    $registro = $linea;
                    array_push($basesDistribucion, $registro);
                } else {
                    $primeraLinea = false;
                }
            }

            fclose($archivo);

            return $this->procesarArchivoBasesDistribucion($basesDistribucion,
                                                           $request->con_fk_id,
                                                           $request->ins_fk_id,
                                                           $request->bdi_ano);
        } else {
            throw new \Exception('Imposible completar la petición.');
        }
    }

    private function procesarArchivoBasesDistribucion($basesDsitribucion, $con_fk_id, $ins_fk_id, $bdi_ano) {
        $resultados = new \stdClass();
        $resultados->errores = "";

        \DB::transaction(function() use(&$resultados, $basesDsitribucion, $con_fk_id, $ins_fk_id, $bdi_ano) {
            if (count($basesDsitribucion) === 0) {
                $resultados->correcto = false;
                $resultados->errores = 'El archivo está vacío. ';
                return json_encode($resultados);
            } else if (count($basesDsitribucion[0]) !== 2) {
                $resultados->correcto = false;
                $resultados->errores = 'La cantidad de columnas no corresponde. ';
                return json_encode($resultados);
            } else {
                $basesDistribucionBd = BasesDistribucion::on('costos_principal')
                                                        ->where('con_fk_id', $con_fk_id)
                                                        ->where('ins_fk_id', $ins_fk_id)
                                                        ->where('bdi_ano', $bdi_ano)
                                                        ->get()->toArray();
                $basesDistribucionExistentes = [];

                // Crear las relaciones existentes en la base de datos
                foreach ($basesDistribucionBd as $bdiDb) {
                    $basesDistribucionExistentes[$bdiDb['bdi_codigo']] = $bdiDb['bdi_pk_id'];
                }

                // Errores de los centros de utilidad
                $registrosProcesados = 0;
                $descripcionesLargas = false;
                $camposVacios = false;

                // Revisar el archivo respecto a las relaciones existentes
                foreach($basesDsitribucion as $bdiCsv) {
                    $codigo = utf8_encode(trim($bdiCsv[0]));
                    $descripcion = utf8_encode(trim($bdiCsv[1]));

                    if ($codigo != "" && $descripcion != "" && trim($codigo) != '1' && trim($codigo) != '2' && trim($codigo) != '3' &&
                        trim($codigo) != '4' && trim($codigo) != '5' && trim($codigo) != '6' && trim($codigo) != '7' && trim($codigo) != '8') {
                        // Descripcion largas
                        if (strlen($codigo) <= 30 && strlen($descripcion) <= 150) {
                            // Existe la base
                            if (!isset($basesDistribucionExistentes[$codigo])) {
                                $baseDistribucion = BasesDistribucion::on('costos_principal');

                                $id = $baseDistribucion->create(
                                    [
                                        "con_fk_id" => $con_fk_id,
                                        "ins_fk_id" => $ins_fk_id,
                                        "bdi_ano" => $bdi_ano,
                                        "bdi_codigo" => $codigo,
                                        "bdi_descripcion" => $descripcion,
                                        "bdi_predefinida" => false
                                    ]
                                );

                                $registrosProcesados++;

                                $basesDistribucionExistentes[$codigo] = $id->bdi_pk_id;
                            } else {
                                BasesDistribucion::on('costos_principal')
                                                 ->where('bdi_pk_id', $basesDistribucionExistentes[$codigo])
                                                 ->where('con_fk_id', $con_fk_id)
                                                 ->where('ins_fk_id', $ins_fk_id)
                                                 ->where('bdi_ano', $bdi_ano)
                                                 ->where('bdi_codigo', $codigo)
                                ->update(
                                    [
                                        "bdi_descripcion" => $descripcion
                                    ]
                                );

                                $registrosProcesados++;
                            }
                        } else {
                            $descripcionesLargas = true;
                        }
                    } else {
                        $camposVacios = true;
                    }
                }

                // Descripciones largas
                if ($descripcionesLargas) {
                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores .= "Hay códigos con más de 30 caracteres o descripciones de más de 150 caracteres";
                }

                // Campos vacios
                if ($camposVacios) {
                    if ($resultados->errores !== "") {
                        $resultados->errores .= "-  ";
                    }

                    $resultados->errores .= "Hay campos vacíos o el código no es válido";
                }

                if (!$descripcionesLargas && !$camposVacios) {
                    $resultados->correcto = true;
                } else {
                    $resultados->correcto = false;
                }

                $resultados->registros = $registrosProcesados;
            }

            $this->verificarAvance($con_fk_id, $ins_fk_id, $bdi_ano);
        });

        return json_encode($resultados);
    }

    public function importarBasesDistribucion(Request $request) {
        \DB::transaction(function() use($request) {
            $anoActual = $request->input('anoActual');
            $anoImportacion = $request->input('anoImportacion');

            // Se importan todas la bases que no existan en el año actual
            // No se importan bases predefinidas ni generadas por mano de obra
            $basesDistribucion = \DB::select("with bdi_actual as (
                                                select bdi_codigo
                                                from costos_principal.bases_distribucion
                                                where con_fk_id = ".$request->input('con_fk_id')." and
                                                      ins_fk_id = '".$request->input('ins_fk_id')."' and
                                                      bdi_ano = ".$anoActual." and
                                                      bdi_predefinida = false and
                                                      bdi_mano_obra = false
                                             )
                                             select bdi_codigo, bdi_descripcion
                                             from costos_principal.bases_distribucion
                                             where con_fk_id = ".$request->input('con_fk_id')." and
                                                   ins_fk_id = '".$request->input('ins_fk_id')."' and
                                                   bdi_ano = ".$anoImportacion." and
                                                   bdi_predefinida = false and
                                                   bdi_mano_obra = false and
                                                   bdi_codigo not in (select bdi_codigo from bdi_actual)");

            foreach($basesDistribucion as $bdi) {
                BasesDistribucion::on('costos_principal')->create(
                    [
                        "con_fk_id" => $request->input('con_fk_id'),
                        "ins_fk_id" => $request->input('ins_fk_id'),
                        "bdi_ano" => $anoActual,
                        "bdi_codigo" => $bdi->bdi_codigo,
                        "bdi_descripcion" => $bdi->bdi_descripcion,
                        "bdi_predefinida" => false,
                        "bdi_mano_obra" => false
                    ]
                );
            }

            $this->verificarAvance($request->input('con_fk_id'),
                                   $request->input('ins_fk_id'),
                                   $anoActual);
        });
    }

    public function verificarAvance($contrato, $institucion, $ano) {
        // Verificar si existe registro del avance
        $conteo = AvanceModulos::on('costos_principal')
                               ->where('con_fk_id', $contrato)
                               ->where('ins_fk_id', $institucion)
                               ->where('avm_ano', $ano)
                               ->whereNull('avm_mes')
                               ->count();

        // Verificar el avance del modulo
        $bdi = BasesDistribucion::on('costos_principal')
                                ->where('con_fk_id', $contrato)
                                ->where('ins_fk_id', $institucion)
                                ->where('bdi_ano', $ano)
                                ->where('bdi_predefinida', false)
                                ->count();

        if ($conteo > 0) {
            if ($bdi > 0) {
                AvanceModulos::on('costos_principal')
                             ->where('con_fk_id', $contrato)
                             ->where('ins_fk_id', $institucion)
                             ->where('avm_ano', $ano)
                             ->where('avm_mes', null)
                ->update(
                    [
                        "avm_bases_distribucion" => true
                    ]
                );
            } else {
                AvanceModulos::on('costos_principal')
                             ->where('con_fk_id', $contrato)
                             ->where('ins_fk_id', $institucion)
                             ->where('avm_ano', $ano)
                             ->where('avm_mes', null)
                ->update(
                    [
                        "avm_bases_distribucion" => false
                    ]
                ); 
            }
        } else {
            AvanceModulos::on('costos_principal')
            ->create(
                [
                    "con_fk_id" => $contrato,
                    "ins_fk_id" => $institucion,
                    "avm_ano" => $ano,
                    "avm_mes" => null,
                    "avm_bases_distribucion" => true
                ]
            );
        }          
    }
}
