<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class LogActividades extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('log_actividades', function (Blueprint $table) {
            $table->increments('log_pk_id');
            $table->string('log_contrato', 200);
            $table->string('log_usuario', 80);
            $table->string('log_tipo_accion', 50)->comment('Acceso incorrecto, Programada');
            $table->string('log_descripcion', 5000);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('log_actividades');
    }
}
