<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class DistribucionIfmCostosCuentas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('distribucion_ifm_costos_cuentas', function (Blueprint $table) {
            $table->increments('dcu_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('dcu_ano');
            $table->integer('dcu_mes');
            $table->integer('ifm_fk_id');
            $table->integer('cco_fk_id');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('ifm_fk_id')->references('ifm_pk_id')->on('informacion_financiera')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');

            $table->index('ifm_fk_id');
            $table->index('cco_fk_id');
            $table->index(['con_fk_id', 'ins_fk_id', 'dcu_ano', 'dcu_mes']);

            $table->unique(['con_fk_id', 'ins_fk_id', 'dcu_ano', 'dcu_mes', 'ifm_fk_id', 'cco_fk_id'], 'dcu_unique');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('distribucion_ifm_costos_cuentas');
    }
}
