<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class DetallePobPrograma extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('detalle_pob_programa', function (Blueprint $table) {
            $table->bigIncrements('dpp_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('dpp_ano');
            $table->integer('dpp_mes');
            $table->integer('sed_fk_id');
            $table->integer('prg_fk_id');
            $table->integer('esp_fk_id');
            $table->integer('dpp_poblacion');
            $table->float('dpp_valor_unitario');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign(['sed_fk_id', 'con_fk_id'])->references(['sed_pk_id', 'con_fk_id'])->on('sedes')->onDelete('cascade');
            $table->foreign('prg_fk_id')->references('prg_pk_id')->on('programas')->onDelete('cascade');
            $table->foreign('esp_fk_id')->references('esp_pk_id')->on('estadios_programas')->onDelete('cascade');

            $table->index(['con_fk_id', 'ins_fk_id', 'dpp_ano', 'dpp_mes', 'sed_fk_id', 'prg_fk_id', 'esp_fk_id'], 'dpp_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'dpp_ano', 'dpp_mes', 'prg_fk_id'], 'dpp_index2');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('detalle_pob_programa');
    }
}
