<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class MonitorContratos extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('monitor_contratos', function (Blueprint $table) {
            $table->increments('mco_pk_id');
            $table->integer('con_fk_id');
            $table->string('ins_fk_id', 50);
            $table->integer('mco_ano');
            $table->integer('mco_mes');
            $table->integer('coe_fk_id');
            $table->integer('cco_fk_id');
            $table->float('mco_ventas');
            $table->float('mco_costos');
            $table->float('mco_resultado');

            $table->foreign('con_fk_id')->references('con_pk_id')->on('contrato')->onDelete('cascade');
            $table->foreign(['ins_fk_id', 'con_fk_id'])->references(['ins_pk_id', 'con_fk_id'])->on('instituciones')->onDelete('cascade');
            $table->foreign('coe_fk_id')->references('coe_pk_id')->on('contratos_eps')->onDelete('cascade');
            $table->foreign('cco_fk_id')->references('cco_pk_id')->on('centros_costo')->onDelete('cascade');

            $table->unique(['con_fk_id', 'ins_fk_id', 'mco_ano', 'mco_mes', 'coe_fk_id', 'cco_fk_id']);

            $table->index(['con_fk_id', 'ins_fk_id', 'mco_ano', 'mco_mes'], 'mco_index1');
            $table->index(['con_fk_id', 'ins_fk_id', 'mco_ano', 'mco_mes', 'coe_fk_id'], 'mco_index2');
            $table->index(['con_fk_id', 'ins_fk_id', 'mco_ano', 'mco_mes', 'coe_fk_id', 'cco_fk_id'], 'mco_index3');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('monitor_contratos');
    }
}
